/***********************************************************************
  
                                SGREP.C
  
A handy little utility for dealing with your SIMTEL index.  Sgrep will
do a case-insensitive search for any string in the SIMTEL human-readable
index, and show you the matching files.  Output can be redirected into a
file.  Invoke as 'sgrep something'.  Sgrep expects to find an
environment variable SIMIDX pointing to the index file. (full pathname,
please)
  
Any key will pause the listing, and you are given the opportunity to
abort.
  
If you use Qedit, this macro will do a SIMTEL lookup on the currently
highlighted word:
  
  
@0 MacroBegin Copy JFalse over:  Dos 'sgrep ' Paste ' >q.tmp' Return \
    Return EditFile 'q.tmp' Return Quit HorizontalWindow EditFile 'q.tmp' \
    Return over:
  
Enter as one line in your QCONFIG.DAT, and Alt-0 will do the lookup.
The output is placed in another window, for your editing and copying
convenience.
  
SGREP.C is placed into the public domain.
  
Roy M. Silvernail
roy%cybrspc@cs.umn.edu
  
1/27/92     Added formatting similar to Keith Peterson's SIMTEL
            citations.  Added busy indicator to stderr output.

3/7/92      Added progress indicator that only shows up when output has
            been redirected.  Hits are shown with periods trailing the
            busy indicator.

3/28/92     If the pattern given matched the text in the
            "Filename   Type Length   Date    Description" header,
            SGREP would print every header.  Fixed.
************************************************************************/
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <keys.h>

static char    *version = "1.3";

int
get_key(void);
void
do_pause(void);


FILE           *infile;

main(int argc, char *argv[])
{
    int             NewDir = 0, count = 0, showhits = 0;
	char            Cdir[82], Cfile[82], Tfile[82];
	char           *fname;
    char            busy[5] = {"\\|/"};


	if (argc == 1) {
		printf("Usage: sgrep string\n");
		exit(1);
	}
	if ((fname = getenv("SIMIDX")) == NULL) {
		fprintf(stderr, "sgrep: can't find environmemnt variable SIMIDX\n");
		exit(1);
	}
	if ((infile = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "sgrep: cant open index file %s!\n", fname);
		exit(1);
	}
    if (!isatty(fileno(stdout))) {
        showhits++;
    }
	fprintf(stderr, "SGREP quick SIMTEL lookup utility V%s\n", version);
	fprintf(stderr, "by Roy M. Silvernail -- %s\n", __DATE__);
	fprintf(stderr, "This program is in the public domain\n");

    strupr(argv[1]);

    while (fgets(Cfile, sizeof(Cfile), infile)) {
		if (kbhit()) {
			do_pause();
		}
		if (strncmp("Directory", Cfile, 9) == 0) {
			strcpy(Cdir, Cfile);
			NewDir = 1;
            fprintf(stderr, "%c\b",busy[(count = (++count & 3))]);
            fgets(Cfile, sizeof(Cfile), infile);
            fgets(Cfile, sizeof(Cfile), infile);
		} else {
			strcpy(Tfile, Cfile);
            strupr(Tfile);
			if (strstr(Tfile, argv[1])) {
				if (NewDir) {
					printf(" \n%s", Cdir);
					printf(" Filename   Type Length   Date    Description\n");
					printf("==============================================\n");
					NewDir = 0;
                }
                if (showhits) {
                    fprintf(stderr,".");
                }
                printf("%s", Cfile);
			}
		}
	}
	fclose(infile);
    return(0);
}


get_key(void)
{
	int             c;

	return (((c = getch()) != 0) ? c : getch() + 256);
}

void
do_pause(void)
{

	get_key();
    fprintf(stderr, "\nProgram paused. Abort? (y/n) ");
	switch (get_key()) {
	case 'y':
	case 'Y':
		fclose(infile);
		exit(0);
		break;
	default:
		putchar('\n');
	}
}
